#!/usr/bin/env python
#-*- coding: utf-8 -*-
import numpy as np
import matplotlib.pyplot as plt

def main():
    
    #Pede valores para gerar grade de temperaturas da estrela e da poeira
    valores = interacao()
    
    #Cria arrays de valores para T1 e T2 com os dados fornecidos acima
    T1 = np.linspace(valores[0], valores[1], valores[4])
    T2 = np.linspace(valores[2], valores[3], valores[4])

    #Lê uma tabela dada e separa as colunas
    arquivo = input("Digite o nome do arquivo com a tabela: ")
    tabela = np.loadtxt(arquivo, skiprows = 1)
    lbd = tabela[:, 0] * 1.E-8 #Feito com conversão de unidades
    fluxo = tabela[:, 1] * 1.E8 #Feito com conversão de unidades
    erro = tabela[:, 2] * 1.E8 #Feito com conversão de unidades
    
    #Faz cálculo do chi quadrado para todas as combinações de T1 e T2 fornecidos
    chi_2 = []
    i = 0

    for t1 in T1:

        chi_2.append([])

        for t2 in T2:

            Smodelo = spec(t1, t2, lbd)
            chi_2[i].append(chi2(Smodelo, fluxo, erro))
    
        i = i + 1

    #Transforma a lista de listas chi_2 em um array de listas
    chi_2 = np.asarray(chi_2)

    #Encontra o valor mínimo do array
    minimo = chi_2.min()
    
    #Fornece os valores de T1 e T2 correspondentes ao menor chi_2 (local[i][j] - i = posição de t1 na lista T1, j = posição de t2 em T2)
    local = np.where(chi_2 == minimo)
    T1minchi = T1[local[0]]
    T2minchi = T2[local[1]]
    
    #Gráfico de chi2 por T1 (com valor de T2 para o mínimo chi2)
    chi2T1 = []
    for c in chi_2:
        chi2T1.append(c[local[1]] - minimo)
        
    plt.plot(T1, chi2T1)
    plt.show()
    
    #Gráfico de chi2 por T2 (com valor de T1 para o mínimo chi2)
    chi2T2 = []
    array = np.array(chi_2[0])
    for c in range(len(array)):
        chi2T2.append(array[c] - minimo)
    
    plt.plot(T2, chi2T2)
    plt.show()
    
    #Plota mapa de contorno de chi2 pelos valores de T1 e T2
    plt.contour(T1, T2, chi_2, cmap='plasma', vmin=minimo, vmax=chi_2.max())
    plt.colorbar()
    plt.xlabel(
    plt.show()

######################################################################################################################################################

def corponegro(lbd, T):
    '''(array, float, float, float, float) -> (array)
    Calcula a função de corpo negro para um dado comprimento de onda lbd e temperatura T.
    Caso não sejam fornecidos, são adotados os valores de 1.381E-16 erg/K, 6.6E-27 erg s e 2.998E10 cm/s
    para as constantes de Boltzmann, de Planck e da velocidade da luz no vácuo, respectivamente.
    '''
    k=1.381E-16
    h=6.626E-27
    c=2.998E10
    pi=3.142
    #Partes do cálculo da função
    expoente = (h * c / (lbd * k * T))    
    divisor = lbd * lbd * lbd * lbd * lbd * (np.exp(expoente) - 1.)
    
    #Cálculo final
    corpo = pi * 2. * h * (c * c) / divisor
    
    return corpo

######################################################################################################################################################

def spec(T1, T2, lbd, sigma=5.670E-5):
    '''(float, float, array, float) -> (matrix)
    Recebe valores de temperatura da estrela T1, da poeira que a envolve T2 e de comprimentos de onda e retorna o valor da função
    corponegro(lbd, T1) / (erro * T1 ** 4) efbeuebgugb TERMNIA ISSAQI DPOIS
    '''
    
    #Calcula a expressão para todos os valores de T1 e T2 no determinado comprimento de onda lbd
    spec1 = corponegro(lbd, T1) / (sigma * (T1 * T1 * T1 * T1))
    spec2 = corponegro(lbd, T2) / (sigma * (T2 * T2 * T2 * T2))
        
    #Faz todas as combinações possíveis de soma entre spec1 e spec2, guardando os valores em spec
    spec = spec1 + spec2
    
    return spec

######################################################################################################################################################

def chi2(ymodelo, y, erro):
    '''(array, array, array) -> (matrix)
    blablabal
    '''

    #Cálculo de (yi - y(xi)) / sigma_i
    termo = (y - ymodelo) / erro

    #Tira o quadrado do termo e soma todas as componentes do array
    chi2 = np.sum(termo * termo)

    return chi2

######################################################################################################################################################

def interacao():
    '''() -> (float, float, float, float, integer)
    Recebe valores máximos e mínimos para as temperaturas de uma estrela T1 e da poeira a envolvendo T2, bem como a quantidade N de valores desejada
    nesses intervalos
    '''
    
    T1_max = float(input("\nDigite um valor máximo para a temperatura da estrela (em K): "))
    T1_min = float(input("Digite um valor mínimo para a temperatura da estrela (em K): "))
    T2_max = float(input("\nDigite um valor máximo para a temperatura da poeira envolvendo essa estrela (em K): "))
    T2_min = float(input("Digite um valor mínimo para a temperatura da poeira envolvendo essa estrela (em K): "))
    N = int(input("\nDigite a quantidade de valores desejados nos intervalos fornecidos (em K): "))


    return T1_max, T1_min, T2_max, T2_min, N

######################################################################################################################################################

#Executando o programa
main()
